
! Copyright (C) 2018 T. Mueller, J. K. Dewhurst, S. Sharma and E. K. U. Gross.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine potksulr
use modmain
use modulr
use modomp
implicit none
! local variables
integer iq,idm,is,ias
integer npc,nthd
! allocatable arrays
real(8), allocatable :: rfmt1(:),rfmt2(:)
! compute the ultra long-range Coulomb potential
call potclulr
! compute the ultra long-range exchange-correlation potential and fields
call potxculr
! subtract the normal Kohn-Sham potential for Q=0
allocate(rfmt1(npcmtmax),rfmt2(npcmtmax))
do ias=1,natmtot
  is=idxis(ias)
  npc=npcmt(is)
  call rfmtftoc(nrmt(is),nrmti(is),vsmt(:,ias),rfmt1)
  call rbsht(nrcmt(is),nrcmti(is),rfmt1,rfmt2)
  vsqmt(1:npc,ias,1)=vsqmt(1:npc,ias,1)-rfmt2(1:npc)
end do
deallocate(rfmt1,rfmt2)
vsqir(:,1)=vsqir(:,1)-vsir(:)
! multiply vsqir by the characteristic function
call omp_hold(nqpt,nthd)
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
do iq=1,nqpt
  vsqir(:,iq)=vsqir(:,iq)*cfunir(:)
end do
!$OMP END DO
!$OMP END PARALLEL
call omp_free(nthd)
if (.not.spinpol) return
! subtract the normal Kohn-Sham magnetic field for Q=0 in the muffin-tins
do idm=1,ndmag
  do ias=1,natmtot
    is=idxis(ias)
    npc=npcmt(is)
    bsqmt(1:npc,ias,idm,1)=bsqmt(1:npc,ias,idm,1)-bsmt(1:npc,ias,idm)
  end do
end do
! multiply bsqir by the characteristic function
call omp_hold(nqpt,nthd)
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP PRIVATE(idm) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
do iq=1,nqpt
  do idm=1,ndmag
    bsqir(:,idm,iq)=bsqir(:,idm,iq)*cfunir(:)
  end do
end do
!$OMP END DO
!$OMP END PARALLEL
call omp_free(nthd)
! subtract the normal Kohn-Sham magnetic field for Q=0 in the interstitial
! (this is already multiplied by the characteristic function)
do idm=1,ndmag
  bsqir(:,idm,1)=bsqir(:,idm,1)-bsir(:,idm)
end do
return
end subroutine

